/**@@@+++@@@@******************************************************************
**
** Microsoft Windows Media
** Copyright (C) Microsoft Corporation. All rights reserved.
**
***@@@---@@@@******************************************************************
*/

//#include <stdlib.h>
// #include <ctype.h>
// #include <string.h>
#include "drmcommon.h"
#include "drmlicense.h"
#include "drmutilities.h"
#include "drmcontextsizes.h"
#include "drmlicstore.h"
#include "drmpkcrypto.h"
#include "drmmanager.h"
#include "tOEMIMP.h"
#include "tclib.h"
#include "tLicGen.h"
#include "tResponsegen.h"
#include "tstutils.h"
#include "tGetClientID.h"
#include "drmcrt.h"
#include "DX_VOS_Utils.h"


extern DRM_RESULT GetLicenseEnum(DRM_KID KID, DRM_DWORD* pdwCount, DRM_LICSTORE_CONTEXT* pLicStoreContext, DRM_LICSTOREENUM_CONTEXT** ppLicEnumContext);

typedef struct _tagOEM_GENERIC_CONTENT_HEADER
{
    DRM_DWORD dwSize;
    DRM_UINT   iChunkSize;
    DRM_UINT   cbDrmHdr;
/*    DRM_BYTE   bDrmHdr[0];*/
} OEM_GENERIC_CONTENT_HEADER;
  
/*global variables*/

static DRM_CONST_STRING g_wszDeviceStoreName = {0};
static DRM_MANAGER_CONTEXT *g_pManagerContext = NULL;
 

#define RESPONSECONTEXTSIZE 50000
long g_lOffsetTime=0;
 
/*************************************************************/

/*to do items
	1. add test codes for API at drmsynclist.h
*/

DRM_RESULT TestSyncListReset(long iIndex, char **argv)
{
	DRM_RESULT dr=DRM_SUCCESS;
  
  	DRM_MGR_Uninitialize(g_pManagerContext);
	DX_VOS_MemSet(g_pManagerContext, 0, sizeof(DRM_MANAGER_CONTEXT));
	
	if (1==OEM_atoi(argv[0])){
		RemoveDRMFile(RMFILE_STORE);
	}
	ChkDR(DRM_MGR_Initialize(g_pManagerContext, &g_wszDeviceStoreName));
 
ErrorExit:
	return dr;
}
/* 
DRM_RESULT DRM_API DRM_SNC_GenerateSyncChallenge (
    IN     DRM_VIEW_RIGHTS_CONTEXT     *f_pcontextViewRights,
    IN     DRM_HDS_CONTEXT			   *f_pcontextHDS,
    IN     DRM_STACK_ALLOCATOR_CONTEXT *f_pcontextStack,
    IN     DRM_DWORD					f_cMaxCount,   smallest number is 1
    IN     DRM_DWORD                    f_cMaxHours,   smallest number is 1
    IN     DRM_DWORD                    f_iKIDStart,   zero based index 
    IN     DRM_DWORD                    f_cKIDs,
       OUT DRM_DWORD                   *f_piKIDNext,
       OUT DRM_DWORD                   *f_pcKIDs,
       OUT DRM_BYTE                    *f_pbChallenge,
    IN OUT DRM_DWORD                   *f_pcbChallenge);
*/
DRM_RESULT TestGenerateSyncListChallenge(long argc, char **argv)
{
#if DRM_SUPPORT_LICENSE_SYNC
	DRM_RESULT dr=DRM_SUCCESS;
  	DRM_DWORD cCountMin=0,cHoursMin=0;
	int iNULLContext=0;
	DRM_DWORD cchChallenge= 0;
	DRM_DWORD iInKIDs       = 0;
	DRM_DWORD iOutKIDs       = 0;
	DRM_DWORD iKIDStart    = 0;
	DRM_DWORD iKIDNext    = 0;
	_XMBContext *pszChallenge = NULL;
	DRM_WCHAR wszConvertedKID[64]     = {0};
	DRM_CONST_STRING wszKID1 = {0};
	DRM_CONST_STRING wszKID2 = {0};
	DRM_CONST_STRING wszKID11 = {0};
	DRM_CONST_STRING wszKID22 = {0};
	DRM_BYTE *pbKID1=NULL, *pbKID2=NULL;
	DRM_DWORD cbKID1=0, cbKID2=0;
	

	int iOption=0;
	
	if(argv[0]==NULL){
		iNULLContext=1;
	}

	if(-1==OEM_atol(argv[1])){
		cCountMin=DRM_SYNC_IGNORE_THRESHOLD_PARAMETER;
	}
 	else{
	 	cCountMin=(DRM_DWORD)OEM_atol(argv[1]);
 	}
	if(-1==OEM_atol(argv[2])){
		cHoursMin=DRM_SYNC_IGNORE_THRESHOLD_PARAMETER;
	}
 	else{
	 	cHoursMin=(DRM_DWORD)OEM_atol(argv[2]);
 	}
 
	iKIDStart=(DRM_DWORD)OEM_atol(argv[6]);
	iInKIDs=(DRM_DWORD)OEM_atol(argv[7]);


 	dr = DRM_MGR_GenerateSyncChallenge(((iNULLContext > 1) ? NULL : g_pManagerContext),
                                       cCountMin, 
                                       cHoursMin, 
                                       iKIDStart,
                                       iInKIDs,
                                       &iKIDNext,
	                                   &iOutKIDs,
   									   NULL, 
                                      &cchChallenge);
    
	if(dr == DRM_E_BUFFERTOOSMALL){ 
     
		ChkMem (pszChallenge = (_XMBContext*)DX_VOS_MemMalloc(cchChallenge));
        ChkDR  (DRM_MGR_GenerateSyncChallenge(g_pManagerContext, 
                                              cCountMin, 
                                              cHoursMin, 
			                                  iKIDStart,
					                          iInKIDs,
							                  &iKIDNext,
									          &iOutKIDs,
                                              pszChallenge, 
                                             &cchChallenge));


	} else {
		ChkDR(dr);
	}
	
	iOption=(int)OEM_atoi(argv[5]);
	/*iOption=1 contains the KID argv[3];
	  iOption=2 does not contain check argv[3];
	  iOption=4 contain argv[4];
	  iOption=8 contain argv[4];
      */
  
	/*verify the list argv[3] and argv[4]*/
	if (argv[3] && pszChallenge){
		/*challenge contains the kid*/
		MakeDRMString(&wszKID1, argv[3]);
		ChkDR(tDRM_B64_Decode(&wszKID1, &cbKID1, &pbKID1)); /* This is a 7 byte key */
		ChkDR(tDRM_B64_Encode(pbKID1, cbKID1, &wszKID11));
		DX_VOS_MemSet(wszConvertedKID, 0, sizeof(wszConvertedKID));
		DRM_wcsncpy(wszConvertedKID,wszKID11.pwszString,cbKID1); 
		if(1&iOption){
  			if (!OEM_wcsstr((DRM_WCHAR*)pszChallenge, wszConvertedKID)){
				ChkDR(DRM_E_FAIL);
			}
		}
		else if(2&iOption){
  			if (OEM_wcsstr((DRM_WCHAR*)pszChallenge, wszConvertedKID)){
				ChkDR(DRM_E_FAIL);
			}
		}
	}
 
	if (argv[4] && pszChallenge){
		/*challenge contains the kid*/
		MakeDRMString(&wszKID2, argv[4]);
		ChkDR(tDRM_B64_Decode(&wszKID2, &cbKID2, &pbKID2)); /* This is a 7 byte key */
		ChkDR(tDRM_B64_Encode(pbKID2, cbKID2, &wszKID22));
		DX_VOS_MemSet(wszConvertedKID, 0, sizeof(wszConvertedKID));
		DRM_wcsncpy(wszConvertedKID,wszKID22.pwszString,cbKID2); 
		if(4&iOption){
  			if (!OEM_wcsstr((DRM_WCHAR*)pszChallenge, wszConvertedKID)){
				ChkDR(DRM_E_FAIL);
			}
		}
		else if(8&iOption){
  			if (OEM_wcsstr((DRM_WCHAR*)pszChallenge, wszConvertedKID)){
				ChkDR(DRM_E_FAIL);
			}
		}
	}

	if(argv[8] && iKIDNext!=(DRM_DWORD)OEM_atol(argv[8]) ){
		ChkDR(DRM_E_FAIL);
	}

	if(argv[9] && iOutKIDs!=(DRM_DWORD)OEM_atol(argv[9]) ){
		ChkDR(DRM_E_FAIL);
	}

ErrorExit:
	DX_VOS_MemFree((void*)wszKID1.pwszString);
	DX_VOS_MemFree((void*)wszKID2.pwszString);
	DX_VOS_MemFree((void*)wszKID11.pwszString);
	DX_VOS_MemFree((void*)wszKID22.pwszString);
	DX_VOS_MemFree(pbKID1);
	DX_VOS_MemFree(pbKID2);
	DX_VOS_MemFree(pszChallenge);
   	return dr;
#else
	return DRM_E_NOTIMPL;
#endif
}

DRM_RESULT TestSetEnhancedData(long argc, char **argv)
{
	DRM_RESULT dr=DRM_SUCCESS;
 	DRM_DWORD cbHeader=0; 
	DRM_BYTE *pbHeader=NULL;
	OEM_GENERIC_CONTENT_HEADER oHeader;
 	DxVosFile fp=NULL;
 	char pszContentFileName[256]={0};
 	DRM_DWORD readBytes=0; 
	 
#ifdef WINCE_TEST
	DX_VOS_SPrintf(pszContentFileName,sizeof(pszContentFileName), "%s\\%s", BASE_DIR, argv[0]);
#else
	DX_VOS_SPrintf(pszContentFileName,sizeof(pszContentFileName) ,".\\%s", argv[0]);
#endif
	DX_VOS_FOpen(&fp,pszContentFileName, "rb");
	if(NULL==fp){
		Log("Trace", "Cannot load file: %s", pszContentFileName);
		ChkDR(DRM_E_FAIL);
	}

	DX_VOS_FReadEx(fp, &oHeader,sizeof( DRM_BYTE)*sizeof( OEM_GENERIC_CONTENT_HEADER),&readBytes);
	if( sizeof( OEM_GENERIC_CONTENT_HEADER ) != readBytes )
	{
		Log("Trace",  "Header couldn't be read");
		ChkDR(DRM_E_FAIL);
	}

	cbHeader=oHeader.cbDrmHdr;
	ChkMem(pbHeader = DX_VOS_MemMalloc(cbHeader));
	DX_VOS_FReadEx(fp, pbHeader,cbHeader,&readBytes);
 	if(cbHeader!=readBytes )
	{
		Log("Trace",  "Header couldn't be read");
		ChkDR(DRM_E_FAIL);
	}
 
 	ChkDR(DRM_MGR_SetV2Header(g_pManagerContext,pbHeader,cbHeader));
ErrorExit:
	DX_VOS_FClose(fp);
 	DX_VOS_MemFree(pbHeader);
  	return dr;
}

static DRM_RESULT tGetSystemTimeString(char* szSystemTimeString, long loffset)
{
 	DRM_RESULT dr = DRM_SUCCESS;
 	DRMSYSTEMTIME tSysTime;
	DRMFILETIME mcFileTime;
	DRM_UINT64 u64;

	ChkArg(szSystemTimeString && loffset);

	OEM_GetDeviceTime(&mcFileTime);
	
	/* offset the file time */
	FILETIME_TO_UI64(mcFileTime, u64);
	if(loffset > 0)
		u64 = DRM_UI64Add(u64, DRM_UI64Mul(DRM_UI64(loffset), DRM_UI64(FILETIME_TO_SECONDS)));
	else
		u64 = DRM_UI64Sub(u64, DRM_UI64Mul(DRM_UI64(-loffset), DRM_UI64(FILETIME_TO_SECONDS)));
	UI64_TO_FILETIME(u64, mcFileTime);

	/*convert back to system time from file time */
	ChkArg(OEM_FileTimeToSystemTime(&mcFileTime, &tSysTime));
 
	/*e.g. 20090101 10:00:00*/
#if 0
	DX_VOS_SPrintf(szSystemTimeString,20, "%i%.2i%.2i %.2i:%.2i:%.2i",tSysTime.wYear,tSysTime.wMonth,tSysTime.wDay,tSysTime.wHour,tSysTime.wMinute,tSysTime.wSecond); 
#else
	/*Dirty workaround because the current DX_VOS_implementaion does not support the .# format*/
	/*Instead build the string step by step */
	DX_VOS_MemSet(szSystemTimeString,'0',20);
	/*print year 4 digits*/
	DX_VOS_SPrintf(szSystemTimeString,20, "%i",tSysTime.wYear); 
	/*print month 2 digits*/
	if(tSysTime.wMonth < 10){
        DX_VOS_IntToStr(0, &szSystemTimeString[4], 4, 10);
        DX_VOS_IntToStr(tSysTime.wMonth, &szSystemTimeString[5], 4, 10);
	}else{
        DX_VOS_IntToStr(tSysTime.wMonth, &szSystemTimeString[4], 4, 10);
	}
	/*print day 2 digits*/
	if(tSysTime.wDay < 10){
        DX_VOS_IntToStr(0, &szSystemTimeString[6], 4, 10);
        DX_VOS_IntToStr(tSysTime.wDay, &szSystemTimeString[7], 4, 10);
	}else{
        DX_VOS_IntToStr(tSysTime.wDay, &szSystemTimeString[6], 4, 10);
	}
	/*print 1 space digits*/
	DX_VOS_SPrintf(&szSystemTimeString[8],4, "%c ",' '); 

	/*print houre 2 digits + : separator*/
    if(tSysTime.wHour < 10){
        DX_VOS_IntToStr(0, &szSystemTimeString[9], 4, 10);
        DX_VOS_IntToStr(tSysTime.wHour, &szSystemTimeString[10], 4, 10);
	}else{
        DX_VOS_IntToStr(tSysTime.wHour, &szSystemTimeString[9], 4, 10);
	}
	DX_VOS_SPrintf(&szSystemTimeString[11],4, "%c ",':'); 

	/*print minute 2 digits + : separator*/
	if(tSysTime.wMinute < 10){
        DX_VOS_IntToStr(0, &szSystemTimeString[12], 4, 10);
        DX_VOS_IntToStr(tSysTime.wMinute, &szSystemTimeString[13], 4, 10);
	}else{
        DX_VOS_IntToStr(tSysTime.wMinute, &szSystemTimeString[12], 4, 10);
	}
	DX_VOS_SPrintf(&szSystemTimeString[14],4, "%c ",':'); 
	/*print seconds 2 digits */
	if(tSysTime.wSecond < 10){
        DX_VOS_IntToStr(0, &szSystemTimeString[15], 4, 10);
        DX_VOS_IntToStr(tSysTime.wSecond, &szSystemTimeString[16], 4, 10);
	}else{
        DX_VOS_IntToStr(tSysTime.wSecond, &szSystemTimeString[15], 4, 10);
	}
#endif
ErrorExit:
	return dr;
}

DRM_RESULT TestAddLicenseToStore(long argc, char **argv)
{
	DRM_RESULT dr=DRM_SUCCESS;
	DRM_CHAR szExtraXML[2000]={0};
	DRM_CONST_STRING pwszLicense;
	ELicenseType eLicType = MAKE_SIMPLE_LICENSE;
	_XMBContext *pbResponseContext = NULL;
	DRM_BYTE *pbResponse = NULL;
	DRM_DWORD cbResponse=0;

 	/*initialize the response xml frame*/
	DX_VOS_MemFree(pbResponseContext);
	ChkMem(pbResponseContext = (_XMBContext *)DX_VOS_MemMalloc(RESPONSECONTEXTSIZE));
	ChkDR(TestResponseInit(pbResponseContext, RESPONSECONTEXTSIZE));
  
	/*
	argv[0]: KID 
	argv[1]: LID 
	argv[2]: option in creating a test license
	argv[3]: extra xml string to add to the license
	argv[4]: offset time
	argv[5]: content sign key
	argv[6]: key seed
	argv[7]: optional license type: 0(simple), 1(leaf), 2(root)
	argv[8]: optional uplink kid
   	*/
	 
   	/*add encrypted and encoded license*/
	ChkDR(TestLicGenInit(10000));
	TestLicGenSetKeys("LICENSE_KID",argv[0]);
	TestLicGenSetKeys("LICENSE_LID",argv[1]);
	if(argv[3])
	{
		if(DX_VOS_FindStr(argv[3],"ExpirationDate=#" ))
		{
			char pSystemTime[20];
			long lOffset;
			ChkArg(argv[4]);
			lOffset=OEM_atol(argv[4])*60*60;
			ChkDR(tGetSystemTimeString(pSystemTime,lOffset));
			DX_VOS_SPrintf(szExtraXML, sizeof(szExtraXML),"%s%s%s", argv[3],pSystemTime,"Z#:0]]></ACTION></ONSTORE>");
 		}
		else
		{
			DX_VOS_StrNCopy(szExtraXML,sizeof(szExtraXML), argv[3]);
		}
 	}
	TestLicGenSetKeys("CONTENT_OWNER_PUB_KEY",argv[5]);
	TestLicGenSetKeys("LICENSE_SERVER_KEYSEED", argv[6]);
 
	if (argc > 7) 
	{
		eLicType = (ELicenseType)OEM_atol(argv[7]);
		if(argc>8)
		{
			ChkDR(TestLicGenSetKeys("LICENSE_UPLINK_KID",argv[8]));
		}
	}

 	ChkDR(TestLicGenMakeLicense(
		OEM_atol(argv[2]),
		argv[3]?szExtraXML:NULL,
		NULL,
		eLicType, 
		&pwszLicense));
	ChkDR(TestResponseAddLicense(pbResponseContext,&pwszLicense));
  	TestLicGenShutDown();
  
	/*get the response*/
   	ChkDR(TestResponseGetResponse(pbResponseContext,&pbResponse,&cbResponse));  
 	ChkDR(DRM_MGR_ProcessLicenseResponse(g_pManagerContext, NULL, NULL, pbResponse, cbResponse));
 
ErrorExit:
	DX_VOS_MemFree(pbResponse);
 	DX_VOS_MemFree(pbResponseContext);
  	return dr;
}


DRM_RESULT TestPlayback(long argc, char **argv)
{
	DRM_DWORD numRights=0;
	DRM_CONST_STRING *pwszRights[1];
	DRM_MANAGER_DECRYPT_CONTEXT *pDecryptContext = NULL;
 	DRM_RESULT dr=DRM_SUCCESS;
 
	/*set rights*/
	ChkMem(pwszRights[numRights] = (DRM_CONST_STRING*)DX_VOS_MemMalloc(sizeof(DRM_CONST_STRING)));
	MakeDRMString(pwszRights[numRights], argv[0]);
	numRights++;
	ChkMem(pDecryptContext = (DRM_MANAGER_DECRYPT_CONTEXT*)DX_VOS_MemMalloc(sizeof(DRM_MANAGER_DECRYPT_CONTEXT)));
   
	/*bind the contentwith license*/
	ChkDR(DRM_MGR_Bind(g_pManagerContext,
		(const DRM_CONST_STRING**)pwszRights,
		numRights,
		NULL,
		NULL,
		pDecryptContext));

	ChkDR(DRM_MGR_Commit( g_pManagerContext ));
ErrorExit:
	while (numRights > 0) {
		numRights--;
		DX_VOS_MemFree((DRM_WCHAR*)pwszRights[numRights]->pwszString);
		DX_VOS_MemFree(pwszRights[numRights]);
	}	
	DX_VOS_MemFree(pDecryptContext);
	pDecryptContext = NULL;

  	return dr;
}

/*argv[0]: offset in seconds, positive to go forward, negative to rollback*/
DRM_RESULT TestSynclistChangeTime(long argc, char **argv)
{
	DRM_RESULT dr=DRM_SUCCESS;
	long lOffset;
 
	ChkArg(argc == 1 && argv[0]);
	lOffset = OEM_atol(argv[0]);
	tChangeSystemTime(lOffset);
	g_lOffsetTime += lOffset;

ErrorExit:
  	return dr;
}

/*
DRM_RESULT GetLicenseEnum(DRM_KID KID, DWORD* pdwCount, DRM_LICSTORE_CONTEXT* pLicStoreContext, DRM_LICSTOREENUM_CONTEXT** ppLicEnumContext)
{	
	DRM_RESULT dr=DRM_SUCCESS;

	ChkArg(pdwCount && ppLicEnumContext);
	
	ChkMem(*ppLicEnumContext = (DRM_LICSTOREENUM_CONTEXT*)DX_VOS_MemMalloc(sizeof(DRM_LICSTOREENUM_CONTEXT)));
	DX_VOS_MemSet(*ppLicEnumContext, 0, sizeof(DRM_LICSTOREENUM_CONTEXT));							

	
	ChkDR(DRM_LST_InitEnum(pLicStoreContext, 
							  &KID,
							  FALSE, //prioritize
							  *ppLicEnumContext));

	ChkDR(DRM_LST_LicCount(*ppLicEnumContext,
							 pdwCount));	
ErrorExit:	
	
	return dr;
}
*/

DRM_RESULT TestEnumLicense_SL(long argc, char **argv)	
{
	/*argv[0]: KID
	    argv[1]: filename to dump license
	    argv[2]: optional, expected number of licenses in the Enum
	  */
	DRM_KID kid;
	DRM_SUBSTRING ssKID = {0,0};/*{0, DX_VOS_StrLen(argv[0])}*/
	DRM_DWORD dwSize = DRM_ID_SIZE;
	DRM_LICSTOREENUM_CONTEXT* pLicStoreEnumContext = NULL;
	DRM_DWORD dwNOLicenses = 0;
	DRM_HDS_CONTEXT oHdsContext;
	DRM_MANAGER_CONTEXT_INTERNAL*  pMgrInternal = (DRM_MANAGER_CONTEXT_INTERNAL*)g_pManagerContext;
	
	DRM_RESULT dr = DRM_SUCCESS;
	ChkArg(argv[0]);
	ChkArg(argv[1] || argv[2]);

	ssKID.m_cch = DX_VOS_StrLen(argv[0]);

	//convert from LPSTR to KID		
	ChkDR(DRM_B64_DecodeA(argv[0],
							  &ssKID,
							  &dwSize,
							  kid.rgb,
							  0));	

	ChkDR(DRM_HDS_Init(&oHdsContext));
	ChkDR(DRM_HDS_OpenStore(g_wszDeviceStoreName.pwszString, &oHdsContext));
	ChkDR(DRM_LST_Open(&pMgrInternal->oLicStoreContext, &oHdsContext));

	ChkDR(GetLicenseEnum(kid, &dwNOLicenses, &pMgrInternal->oLicStoreContext, &pLicStoreEnumContext));

	if (argv[2]) //check the number of licenses expected
	{
		if (OEM_atol(argv[2]) != dwNOLicenses)
		{
			Log("Trace", "Number of License (%d)  with the KID is not match expected", dwNOLicenses);
			ChkDR(E_FAIL);
		}
	}

	if (0 != DX_VOS_StrCmp(argv[1], "") )
	{
		//dump the licenses to the specified file
	}
	
ErrorExit:

	DRM_LST_Close(&pMgrInternal->oLicStoreContext);
	DRM_HDS_CloseStore(&oHdsContext);
	DRM_HDS_Uninit(&oHdsContext);

	if (NULL != pLicStoreEnumContext)
	{
		DX_VOS_MemFree(pLicStoreEnumContext);
	}
	
	return dr;
}
 
DRM_RESULT SL_PreTestCase(long lTCID, char *strTCName)
{
	DRM_RESULT dr;
	CLIENTID clientID;
	const DRM_WCHAR devCertTemplate[] = { TWO_BYTES('d','e'), TWO_BYTES('v','c'),
									 	  TWO_BYTES('e','r'), TWO_BYTES('t','t'),
										  TWO_BYTES('e','m'), TWO_BYTES('p','l'),
										  TWO_BYTES('a','t'), TWO_BYTES('e','.'),
										  TWO_BYTES('d','a'), TWO_BYTES('t','\0') };
	const DRM_WCHAR priv[] = { TWO_BYTES('p','r'), TWO_BYTES('i','v'), TWO_BYTES('.','d'),
							   TWO_BYTES('a','t'), TWO_BYTES('\0',0) };

	g_lOffsetTime=0;
	ChkDR(RemoveDRMFile(RMFILE_STORE));
    /*DX: added full path*/
	ChkDR(SetDeviceEnv(devCertTemplate, priv, FALSE));

	ChkMem(g_pManagerContext = (DRM_MANAGER_CONTEXT*)DX_VOS_MemMalloc(sizeof(DRM_MANAGER_CONTEXT)));
	tGetDeviceStorePathname(&g_wszDeviceStoreName);
 	ChkDR(DRM_MGR_Initialize(g_pManagerContext, &g_wszDeviceStoreName));
	ChkDR(TestGetClientID(&clientID));
	ChkDR(TestLicResponseSetClientID(&clientID));

ErrorExit:
	return dr;
}

DRM_RESULT SL_PostTestCase(long lTCID, char *strTCName)
{
	tChangeSystemTime(-g_lOffsetTime); /* Reverse any time changes in the test case.*/
	g_lOffsetTime=0;

 	if (g_pManagerContext) {
		DRM_MGR_Uninitialize(g_pManagerContext);
		DX_VOS_MemFree(g_pManagerContext);
		g_pManagerContext = NULL;
	}
 
  	RemoveDRMFile(RMFILE_STORE);

	return DRM_SUCCESS;
}

/*
IMPLEMENT_DEFAULT_WARPTEST

BEGIN_TEST_SCRIPT_LIST
	TEST_SCRIPT_ENTRY("Testsynclist")	
END_TEST_SCRIPT_LIST

BEGIN_APIMAP_WITH_SCRIPT_LIST(testsynclist_ansi)
	API_ENTRY(TestSyncListReset)
 	API_ENTRY(TestGenerateSyncListChallenge)
	API_ENTRY(TestAddLicenseToStore)
	API_ENTRY(TestSetEnhancedData)
	API_ENTRY(TestPlayback)
	API_ENTRY(TestSynclistChangeTime)
	API_ENTRY(TestEnumLicense_SL)
END_APIMAP
*/
